
cap program drop regnow
program define regnow
cap drop _*
tsset, clear
reghdfe $y $n_pols $if, absorb($others) vce(cluster $gr3) 
outreg2 $n_pols using "${dir5}${type}_${y}", tex bdec(3) nocons $append ct($ct) label sortvar(n_pols)
end

global y1="tot_wg"
global y2="n_paid_m"
global y3="empl"

forvalues i=1(1)3 {
global y="${y`i'}"

global geo="p_b"


** Table 1

use if age<=65 using "${dir3}mergedCF1_noPA", clear

bysort id: egen tot=count(year)
keep if tot!=. & tot!=1
drop tot

bysort CF1 c_b year: egen pippo=count(year)
bysort CF1 c_b: egen fr_c_new=median(pippo)
foreach var of varlist n_pols n_pols_ing n_pols_out {
   gen `var'2=`var'/fr_c_new
}
drop pippo

replace n_pols_ing_p_ten_c_t_01=n_pols_ing_p_ten_c_t_01+n_pols_ing2_p_ten_c_t_01
replace n_pols_ing_p_ten_c_t_12=n_pols_ing_p_ten_c_t_12+n_pols_ing2_p_ten_c_t_12
replace n_pols_ing_p_ten_c_t_gt2=n_pols_ing_p_ten_c_t_gt2+n_pols_ing2_p_ten_c_t_gt2

global type="Main"
global gr3="c_b"
global append="replace"
global n_pols="n_pols"
global if="if fr_c_new<=30"
global ct=""
g tmp=1
global others="tmp"
regnow

global type="Main"
global gr3="c_b"
global append="append"
global n_pols="n_pols"
global if="if fr_c_new<=30"
global ct="+ controls & FE"
global others="id $geo##year aged"
regnow

global type="Main"
global gr3="c_b"
global append="append"
global n_pols="n_pols_ing"
global if="if fr_c_new<=30"
global ct="In only"
global others="id $geo##year aged"
regnow

global type="Main"
global gr3="c_b"
global append="append"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new<=30"
global ct="In/out"
global others="id $geo##year aged"
regnow


** Table 2

* by occ
gen occupation=.
replace occupation=1 if occ_gr==2 | occ_gr==3
replace occupation=2 if occ_gr==4 | occ_gr==5
replace occupation=3 if occ_gr==6
g ${y}_occ1=${y}*(occupation==1)
global type="Het_work"
global gr3="c_b"
cap drop old
g old=$y
replace $y=${y}_occ1
global append="replace"
global others="id $geo##year aged"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new<=30"
global ct="occ==1"
regnow
replace $y=old
drop old
global i=2
while $i<=3 {
cap drop ${y}_occ${i}
g ${y}_occ${i}=${y}*(occupation==$i)
global type="Het_work"
global gr3="c_b"
cap drop old
g old=$y
replace $y=${y}_occ${i}
global append="append"
global others="id $geo##year aged"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new<=30"
global ct="occ==$i"
regnow
replace $y=old
drop old
global i=$i+1
}

* by age
global i=1
while $i<=5 {
g n_pols_age${i}=n_pols_ing*(aged==$i)
global i=$i+1
}
replace n_pols_age2=n_pols_age1+n_pols_age2
replace n_pols_age3=n_pols_age3+n_pols_age4
drop n_pols_age4
rename n_pols_age5 n_pols_age4
label var n_pols_age2 "Politicians X age 18-35"
label var n_pols_age3 "Politicians X age 36-55"
label var n_pols_age4 "Politicians X age 56-65"
global type="Het_work"
global gr3="c_b"
global append="append"
global others="id $geo##year aged"
global n_pols="n_pols_age2-n_pols_age4 n_pols_out"
global if="if fr_c_new<=30"
global ct="by age"
regnow

* by gender
global i=0
while $i<=1 {
g n_pols_fem${i}=n_pols_ing*(fem==$i)
global i=$i+1
}
label var n_pols_fem0 "Politicians X male"
label var n_pols_fem1 "Politicians X female"
global type="Het_work"
global gr3="c_b"
global append="append"
global others="id $geo##year aged"
global n_pols="n_pols_fem0 n_pols_fem1 n_pols_out"
global if="if fr_c_new<=30"
global ct="by gender"
regnow

global type="Het_work"
global gr3="c_b"
global append="append"
global others="id $geo##year aged"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new<=30 & fem==0"
global ct="by gender"
regnow

global type="Het_work"
global gr3="c_b"
global append="append"
global others="id $geo##year aged"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new<=30 & fem==1"
global ct="by gender"
regnow

* by workers' and politicians' age & gender 
global type="Het_work"
global gr3="c_b"
global append="append"
global others="id $geo##year aged"
global n_pols="n_pols_ing_p_young n_pols_ing_p_mid n_pols_ing_p_old n_pols_out_p_young n_pols_out_p_mid n_pols_out_p_old"
global if="if fr_c_new<=30 & age<=36"
global ct="by politician age"
regnow

global type="Het_work"
global gr3="c_b"
global append="append"
global others="id $geo##year aged"
global n_pols="n_pols_ing_p_mal n_pols_ing_p_fem n_pols_out_p_fem n_pols_out_p_mal"
global if="if fr_c_new<=30 & age<=36"
global ct="by politician age"
regnow

global type="Het_work"
global gr3="c_b"
global append="append"
global others="id $geo##year aged"
global n_pols="n_pols_ing_p_mal_young n_pols_ing_p_mal_mid n_pols_ing_p_mal_old n_pols_ing_p_fem_young n_pols_ing_p_fem_mid n_pols_ing_p_fem_old n_pols_out_p_mal_young n_pols_out_p_mal_mid n_pols_out_p_mal_old n_pols_out_p_fem_young n_pols_out_p_fem_mid n_pols_out_p_fem_old"
global if="if fr_c_new<=30 & age<=36"
global ct="by politician age"
regnow


** Table 3

* drop never connected
global type="Robust"
global append="replace"
global gr3="c_b"
global n_pols="n_pols_ing n_pols_out"
global ct="Drop never connected"
global others="id $geo##year aged"
global if="if fr_c_new<=30"
preserve
drop if max_n_pols==0
regnow
restore

* individual linear trends
global type="Robust"
global append="append"
global gr3="c_b"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new<=30"
global ct="Individual linear trends"
global others="id#c.year $geo##year aged"
regnow

* time-varying FE
cap drop y_gr*
egen minyear=min(year)
gen y_gr2=int((year-minyear)/2)
gen y_gr4=int((year-minyear)/4)
gen y_gr4_bis=int((year-minyear+1)/4)
gen y_gr4_ter=int((year-minyear+2)/4)
gen y_gr4_quater=int((year-minyear+3)/4)
gen y_gr8=int((year-minyear)/8)
gen y_gr8_bis=int((year-minyear+4)/8)
drop minyear

global type="Robust"
global append="append"
global gr3="c_b"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new<=30"
global ct="8 yrs block FE"
global others="id#y_gr8 $geo##year aged"
regnow

global type="Robust"
global append="append"
global gr3="c_b"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new<=30"
global ct="4 yrs block FE"
global others="id#y_gr4 $geo##year aged"
regnow

global type="Robust"
global append="append"
global gr3="c_b"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new<=30"
global ct="2 yrs block FE"
global others="id#y_gr2 $geo##year aged"
regnow


** Table 4

global type="Robust2"
global append="replace"
global n_pols="n_pols_ing2 n_pols_out2"
global if=""
global gr3="gr3"
global ct="Rescaled by freq"
global others="id $geo##year aged"
regnow

global type="Robust2"
global append="append"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new==1"
global gr3="gr3"
global ct="freq=1"
global others="id $geo##year aged"
regnow

global type="Robust2"
global append="append"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new>1 & fr_c_new<=5"
global gr3="gr3"
global ct="2<=freq<=5"
global others="id $geo##year aged"
regnow

global type="Robust2"
global append="append"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new>5 & fr_c_new<=30"
global gr3="gr3"
global ct="6<=freq<=30"
global others="id $geo##year aged"
regnow

global type="Robust2"
global append="append"
global n_pols="n_pols_ing n_pols_out"
global if="if fr_c_new>30"
global gr3="gr3"
global ct="freq>30"
global others="id $geo##year aged"
regnow


** Table 6

* by office
global type="Het_pol"
global gr3="c_b"
global append="replace"
global others="id $geo##year aged"
global ct="by office"
global n_pols="n_pols_ing_p_cou n_pols_ing2_p_cou n_pols_ing_p_top n_pols_ing2_p_top n_pols_out_p_cou n_pols_out_p_top"
global if="if fr_c_new<=30"
regnow

* by tenure
global type="Het_pol"
global gr3="c_b"
global append="append"
global others="id $geo##year aged"
global ct="by tenure"
global n_pols="n_pols_ing_p_ten_c_t_01 n_pols_ing_p_ten_c_t_12 n_pols_ing_p_ten_c_t_gt2 n_pols_out_p_ten_c_t_01 n_pols_out_p_ten_c_t_12 n_pols_out_p_ten_c_t_gt2 n_pols_cens_85"
global if="if fr_c_new<=30"
regnow

* by admin
global type="Het_pol"
global gr3="c_b"
global append="append"
global others="id $geo##year aged"
global ct="by admin"
global n_pols="n_pols_ing_p_c n_pols_ing_p_p n_pols_ing_p_r n_pols_ing_p_n n_pols_out_p_c n_pols_out_p_p n_pols_out_p_r n_pols_out_p_n"
global if="if fr_c_new<=30"
regnow

}
